/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.input.AbstractInput;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;

public class ScaleInput
extends AbstractInput {
    private int orientation = 256;
    private boolean focus = false;
    private boolean enabled = true;
    private Scale scale = null;
    private int value = 0;
    private int minimum = 0;
    private int maximum = 100;
    private int increment = 1;
    private int page = 10;

    public ScaleInput(int value) {
        this(value, 256);
    }

    public ScaleInput(int value, int orientation) {
        this.value = value;
        if (orientation == 256 || orientation == 512) {
            this.orientation = orientation;
        }
    }

    public void setScaling(int minimum, int maximum, int increment, int pageIncrement) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.increment = increment;
        this.page = pageIncrement;
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setMaximum(this.maximum);
            this.scale.setMinimum(this.minimum);
            this.scale.setIncrement(this.increment);
            this.scale.setPageIncrement(this.page);
        }
    }

    @Override
    public Object getValue() {
        if (this.scale == null || this.scale.isDisposed()) {
            return this.value;
        }
        return this.scale.getSelection();
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Number)) {
            return;
        }
        this.value = ((Number)value).intValue();
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setSelection(this.value);
        }
    }

    @Override
    public Control getControl() {
        if (this.scale != null && !this.scale.isDisposed()) {
            return this.scale;
        }
        this.scale = new Scale(this.getParent(), this.orientation | 0);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.scale.setToolTipText(tooltip.toString());
        }
        this.scale.setEnabled(this.enabled);
        this.scale.setMaximum(this.maximum);
        this.scale.setMinimum(this.minimum);
        this.scale.setIncrement(this.increment);
        this.scale.setPageIncrement(this.page);
        this.scale.setSelection(this.value);
        if (this.focus) {
            this.scale.setFocus();
        }
        return this.scale;
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setFocus();
        }
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setEnabled(this.enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

